
	subroutine fd_model 

	include 'common.h'
	real taper(nx)


	write(*,*)' Begin model '

c initialize model

	if(model_type==1)then

	mu=rho0*vs0**2
	lam=rho0*vp0**2-2*mu
	rho=rho0

	elseif(model_type==2)then

c thin layer 100m

	nl=nint(100./dx)

        rho=rho0
        mu=rho0*vs0**2
        lam=rho*vp0**2-2*mu

	rho(:,nz/2-nl/2:nz/2+nl/2)=rho(:,nz/2-nl/2:nz/2+nl/2)
	mu(:,nz/2-nl/2:nz/2+nl/2)=.7*mu(:,nz/2-nl/2:nz/2+nl/2)
	lam(:,nz/2-nl/2:nz/2+nl/2)=.7*lam(:,nz/2-nl/2:nz/2+nl/2)
	
	endif

	write(*,*)minval(rho),' < rho < ',maxval(rho)
	window=1.
	if(nabs>0)then
	call fd_absorb_model
	endif
	write(*,*)minval(rho),' < rho < ',maxval(rho)


c calculate dt from stability

	vmax=maxval( sqrt((lam+2*mu)/rho) )
	dt=0.5* dx/(sqrt(2.)*vmax)

c save cut through model

	open(unit=30,file='DATA/model')
	do i=1,nz
	write(30,*)rho(nx/2,i)
	enddo
	do i=1,nz
	write(30,*)sqrt(mu(nx/2,i)/rho(nx/2,i))
	enddo
	do i=1,nz
	write(30,*)sqrt((lam(nx/2,i)+mu(nx/2,i))/rho(nx/2,i))
	enddo
	close(30)



	write(*,*)' End model '

	return
	end

c ------------------------------------------------

	subroutine fd_absorb_model

	include 'common.h'
	real taper(nx)

c taper parameters

	aabs=3.*nabs
	
c initialise spatial window

	window=1.
	tmp=1.
	do i=1,nabs
	taper(nabs+1-i)=exp(-1./aabs**2*(i-1)**2)	
	enddo
	

	do i=1,nabs
	window(i,:)=taper(i)
	window(nx+1-i,:)=taper(i)
	tmp(:,i)=taper(i)
	tmp(:,nz+1-i)=taper(i)
	enddo
	window=window*tmp
	window=window/maxval(window)
	write(*,*)minval(window),' < window < ',maxval(window)
	
	write(*,*)' Saving window '
        open(unit=20,file=seisfile(1:lnblnk(seisfile))//'_wd',status='unknown')
        do i=1,nx,iout
        do j=1,nz,iout
        write(20,*)window(i,j)
        enddo
        enddo
	close(20)


	return
	end

