c ----------------------------------------------------

	subroutine init_der_matrix

	include 'common.h'

	real x(0:nx)
	real z(0:nz)
	real cx(0:nx)
	real cz(0:nz)

c initialize coordinates

	do ix=0,nx
	x(ix)=cos(pi*ix/nx)
	enddo

      do iz=0,nz
	z(iz)=cos(pi*iz/nz)
	enddo

c  initialize derivative operators  (nx)

	cx(0)=2.
	cx(nx)=2.
	cx(1:nx-1)=1.

c diagonal

	do i=0,nx
	do j=0,nx

	if(i==j)then
	if(i.ne.0.and.i.ne.nx)then
	dmx(i,i)=-x(i)/(2*(1-x(i)*x(i)))
	endif
	else
	dmx(i,j)=(cx(i)*(-1)**(i+j))/(cx(j)*(x(i)-x(j)))
	endif

	enddo
	enddo

c  corners

	dmx(0,0)=(2*nx*nx+1)/6	
	dmx(nx,nx)=-dmx(0,0)

c  initialize derivative operators  (nx)

	cz(0)=2.
	cz(nz)=2.
	cz(1:nz-1)=1.

c diagonal

	do i=0,nz
	do j=0,nz

	if(i.eq.j)then
	if(i.ne.0.and.i.ne.nz)then
	dmz(i,i)=-z(i)/(2*(1-z(i)*z(i)))
	endif
	else
	dmz(i,j)=(cz(i)*(-1)**(i+j))/(cz(j)*(z(i)-z(j)))
	endif

	enddo
	enddo

c  corners

	dmz(0,0)=(2*nz*nz+1)/6	
	dmz(nz,nz)=-dmz(0,0)

c calculate transpose

	dmz=transpose(dmz)

	return 
	end

c -----------------------------------------------

	subroutine pder(out,in,cdir)

	include 'common.h'

	real in(0:nx,0:nz)
	real out(0:nx,0:nz)
	character*1 cdir 



	if(cdir=='x')then
	out=matmul(dmx,in)
	elseif(cdir=='z')then
	out=matmul(in,dmz)
	endif

	return
	end
