
	subroutine ch_init

	include 'common.h'

        real x(0:nx)   ! computaional domain
        real z(0:nz)   ! computaional domain
	real gx(0:nx)  ! stretching  function
	real gz(0:nz)  ! stretching  function

	write(*,*)' Begin init '

cccccccccccccccccccccccccccccccccccccccccccc
ccc Source time function 
cccccccccccccccccccccccccccccccccccccccccccc

c source (half the time step becuase of 4th order RK)

	if(aa.ne.0)then

	dt2=dt/2.
	call ricker(dt2,2*nt,aa,so)

c normalize
	
	smax=0.
	do i=1,2*nt
	if(abs(so(i)).gt.smax)then
	smax=abs(so(i))
	endif
	enddo
	do i=1,2*nt
	so(i)=so(i)/smax*1./2.*nx
	enddo

	else

	it0=50
	so=0.
	so(it0:it0+1)=1/2.*nx

	endif

	open(unit=33,file=seisfile(1:lnblnk(seisfile))//'_src')
	do i=1,2*nt
	write(33,*)so(i)
	enddo
 11	format(e10.5)
	close(33)

cccccccccccccccccccccccccccccccccccccccccccccc
cccc Derivative operator dmx dmz 
cccccccccccccccccccccccccccccccccccccccccccccc

c initialize derivative operator

	call init_der_matrix

cccccccccccccccccccccccccccccccccccccccccccccc
cccc Grid Stretching operator 
cccccccccccccccccccccccccccccccccccccccccccccc

c init grid stretching 

c initialize coordinates

      do ix=0,nx
	  x(ix)=cos(pi*ix/nx)
	end do
      do iz=0,nz
	z(iz)=cos(pi*iz/nz)
	end do

	if(istretch==1)then

c in x direction

	gx=asin(gammax*x)/asin(gammax)	

	xs=xmax/2.*(1.-gx)

	open(unit=30,file=seisfile(1:lnblnk(seisfile))//'_xco')
	do ix=0,nx
	write(30,*)xs(ix)
	enddo
	close(30)
	
c correction for derivatives

	do ix=0,nx
	sx(ix,:)=
     &	2.*asin(gammaz)/(gammaz*xmax)*sqrt(1.-gammaz*gammaz*x(ix)*x(ix))
	end do
	
c in z direction

	gz=asin(gammaz*z)/asin(gammaz)	

	zs=zmax/2.*(1.-gz)

	open(unit=30,file=seisfile(1:lnblnk(seisfile))//'_zco')
	do iz=0,nz
	write(30,*)zs(iz)
	enddo
	close(30)
	
c correction for derivatives

	do iz=0,nz
	sz(:,iz)=
     &	2.*asin(gammaz)/(gammaz*zmax)*sqrt(1.-gammaz*gammaz*z(iz)*z(iz))
	end do
	
	else

	sx=2./xmax
	sz=2./zmax

	endif
cccccccccccccccccccccccccccccccccccccccccccccccc
cccc Spatial source distribution
cccccccccccccccccccccccccccccccccccccccccccccccc

	if(alpha.ne.0.)then

c source gauss

	alpha=1./(alpha*alpha)
	do ix=0,nx
	do iz=0,nz
	gauss(ix,iz)=
     &  exp( -alpha *( (xs(ix)-xxs)**2 +(zs(iz)-zzs)**2 ))
	end do
	end do

	else

	isx=maxval(minloc(abs(xs-xxs)))
	isz=maxval(minloc(abs(zs-zzs)))

	write(*,*)' Source delta at : ',isx,isz

	gauss=0.
	gauss(isx,isz)=1.
	write(*,*)minval(gauss),' < gauss < ',maxval(gauss)

	endif

c output

	open(unit=20,file=seisfile(1:lnblnk(seisfile))//'_gauss')
	do i=0,nx
	do j=0,nz
	write(20,*)gauss(i,j)
	enddo
	enddo

ccccccccccccccccccccccccccccccccccccccccccccc

	write(*,*)' End init '

	return
	end

c--------------------------------------------------

c ricker wavelet

        subroutine ricker(dt,nt,f0,source)
	
	real source(*)
        
	do it=1,nt
        t0=((1./f0)/dt)+20.
        pi=3.141592654
        om2=4.*pi*pi*f0*f0
        a2=4./om2
        arg=dt*dt*(it-t0)*(it-t0)/a2
        if(it.gt.(2.*t0))goto 1
        if(arg.gt.15)then
	ri=0.
	goto 1
	endif
        ri=-(1.-2.*arg)*exp(-arg)
c	write(*,*)ri
	
 1	source(it)=ri
	enddo	
	
        return
        end

