	
	subroutine ch_evolution

	include 'common.h'

	real d1(5,0:nx,0:nz)
	real d2(5,0:nx,0:nz)
	real d3(5,0:nx,0:nz)
	real d4(5,0:nx,0:nz)
	real tmp1(0:nx,0:nz)
	real tmp2(0:nx,0:nz)


c global checks

	if(mod(it,icheck)==0)then
	write(*,*)' Values at it = ',it
	write(*,*)minval(w(1,1,:,:)),' < v_x < ',maxval(w(1,1,:,:))
	write(*,*)minval(w(1,2,:,:)),' < v_z < ',maxval(w(1,2,:,:))
c	write(*,*)minval(w(1,3,:,:)),' < s_11 < ',maxval(w(1,3,:,:))
c	write(*,*)minval(w(1,4,:,:)),' < s_22 < ',maxval(w(1,4,:,:))
c	write(*,*)minval(w(1,5,:,:)),' < s_12 < ',maxval(w(1,5,:,:))
	endif

c calculate acceleration and stress(dotted)

c
c fourth order Runge Kutta Method

c store the n-th time step in w(3,:,:,:)

	w(3,:,:,:)=w(1,:,:,:)

	do ik=1,tord


	do i=1,5
	if(ik==1)continue
	if(ik==2)w(1,i,:,:)=w(3,i,:,:)+dt/2.*d1(i,:,:)
	if(ik==3)w(1,i,:,:)=w(3,i,:,:)+dt/2.*d2(i,:,:)
	if(ik==4)w(1,i,:,:)=w(3,i,:,:)+dt*d3(i,:,:)
	enddo

c add source(s)

	if(source_type==1)then
	if(ik==1) w(1,1,:,:)=w(1,1,:,:)+gauss*so(2*it)
	if(ik==2) w(1,1,:,:)=w(1,1,:,:)+gauss*so(2*it+1)
	if(ik==3) w(1,1,:,:)=w(1,1,:,:)+gauss*so(2*it+1)
	if(ik==4) w(1,1,:,:)=w(1,1,:,:)+gauss*so(2*it+2)
	elseif(source_type==2)then
	if(ik==1) w(1,2,:,:)=w(1,2,:,:)+gauss*so(2*it)
	if(ik==2) w(1,2,:,:)=w(1,2,:,:)+gauss*so(2*it+1)
	if(ik==3) w(1,2,:,:)=w(1,2,:,:)+gauss*so(2*it+1)
	if(ik==4) w(1,2,:,:)=w(1,2,:,:)+gauss*so(2*it+2)
	elseif(source_type==3)then
	if(ik==1) w(1,3,:,:)=w(1,3,:,:)+gauss*so(2*it)
	if(ik==2) w(1,3,:,:)=w(1,3,:,:)+gauss*so(2*it+1)
	if(ik==3) w(1,3,:,:)=w(1,3,:,:)+gauss*so(2*it+1)
	if(ik==4) w(1,3,:,:)=w(1,3,:,:)+gauss*so(2*it+2)
	if(ik==1) w(1,4,:,:)=w(1,4,:,:)+gauss*so(2*it)
	if(ik==2) w(1,4,:,:)=w(1,4,:,:)+gauss*so(2*it+1)
	if(ik==3) w(1,4,:,:)=w(1,4,:,:)+gauss*so(2*it+1)
	if(ik==4) w(1,4,:,:)=w(1,4,:,:)+gauss*so(2*it+2)
	elseif(source_type==4)then
	if(ik==1) w(1,5,:,:)=w(1,5,:,:)+gauss*so(2*it)
	if(ik==2) w(1,5,:,:)=w(1,5,:,:)+gauss*so(2*it+1)
	if(ik==3) w(1,5,:,:)=w(1,5,:,:)+gauss*so(2*it+1)
	if(ik==4) w(1,5,:,:)=w(1,5,:,:)+gauss*so(2*it+2)
	endif


c (1) vi_x


	call pder(tmp1,w(1,3,:,:),'x')
	call pder(tmp2,w(1,5,:,:),'z')
	w(2,1,:,:)=1/rho*( tmp1*sx + tmp2*sz )

c (2) vi_z


	call pder(tmp1,w(1,5,:,:),'x')
	call pder(tmp2,w(1,4,:,:),'z')
	w(2,2,:,:)=1/rho*( tmp1*sx + tmp2*sz )

c (3) sigma_11


	call pder(tmp1,w(1,1,:,:),'x')
	call pder(tmp2,w(1,2,:,:),'z')
	w(2,3,:,:)=(lam+2*mu)*tmp1*sx
     &			+ lam*tmp2*sz


c (4) sigma_22

	w(2,4,:,:)=(lam+2*mu)*tmp2*sz
     &			+ lam*tmp1*sx

c (5) sigma_12

	call pder(tmp1,w(1,2,:,:),'x')
	call pder(tmp2,w(1,1,:,:),'z')
	w(2,5,:,:)=mu*( tmp1*sx + tmp2*sz )

	do i=1,5
	if(ik==1) d1(i,:,:) = w(2,i,:,:)
	if(ik==2) d2(i,:,:) = w(2,i,:,:)
	if(ik==3) d3(i,:,:) = w(2,i,:,:)
	if(ik==4) d4(i,:,:) = w(2,i,:,:)
	enddo

	enddo

c final fourth order extrapolation

	if(tord.eq.1)then
	do i=1,5
	w(1,i,:,:)= w(3,i,:,:)+ dt * d1(i,:,:)
	enddo
	endif

	if(tord.eq.2)then
	do i=1,5
	w(1,i,:,:)= w(3,i,:,:)+ dt * d2(i,:,:)
	enddo
	endif


	if(tord.eq.4)then
	do i=1,5					
	w(1,i,:,:)= w(3,i,:,:)+ 1./6. * dt * 
     &	(d1(i,:,:)+2*d2(i,:,:)+2*d3(i,:,:)+d4(i,:,:))
	enddo
	endif

c boundary condition

	if (ibound.eq.1)then
	call free_surfaces
	else if (ibound.eq.2)then
	call absorbing_boundaries
	else if (ibound.eq.3)then
	call free_surface_and_absorbing
	else if (ibound.eq.4)then
	call circular
	end if

	return
	end
