c -------------------------------------------------------

	subroutine free_surfaces

	include 'common.h'

c boundary treatment

c top boundary z=1; iz=0

	w(1,3,1:nx-1,0)=     
     &		w(1,3,1:nx-1,0)-lam(1:nx-1,0)/(lam(1:nx-1,0)+2*mu(1:nx-1,0
     &        ))*w(1,4,1:nx-1,0)

	w(1,2,1:nx-1,0)=w(1,2,1:nx-1,0)-     
     &	1./sqrt(rho(1:nx-1,0)*(lam(1:nx-1,0)+2*mu(1:nx-1,0)))*w(1,4,1:
     &    nx-1,0)

	w(1,1,1:nx-1,0)=w(1,1,1:nx-1,0)-     
     &		1./sqrt(rho(1:nx-1,0)*mu(1:nx-1,0))*w(1,5,1:nx-1,0)

	w(1,4,1:nx-1,0)=0.

	w(1,5,1:nx-1,0)=0.

c bottom boundary z=-1; iz=nz

	w(1,3,1:nx-1,nz)=
     &	w(1,3,1:nx-1,nz)-lam(1:nx-1,nz)/(lam(1:nx-1,nz)+2*mu(1:nx-1,nz
     &    ))*w(1,4,1:nx-1,nz)

	w(1,2,1:nx-1,nz)=w(1,2,1:nx-1,nz)+
     &	1./sqrt(rho(1:nx-1,nz)*(lam(1:nx-1,nz)+2*mu(1:nx-1,nz)))*w(1,4
     &    ,1:nx-1,nz)

	w(1,1,1:nx-1,nz)=w(1,1,1:nx-1,nz)+
     &  1./sqrt(rho(1:nx-1,nz)*mu(1:nx-1,nz))*w(1,5,1:nx-1,nz)

	w(1,4,1:nx-1,nz)=0.

	w(1,5,1:nx-1,nz)=0.

c right boundary x=1; ix=0

	w(1,4,0,1:nz-1)=w(1,4,0,1:nz-1)-lam(0,1:nz-1)/(lam(0,1:nz-1)+2*mu(
     &           0,1:nz-1))*w(1,3,0,1:nz-1)

	w(1,2,0,1:nz-1)=w(1,2,0,1:nz-1)-
     &	1./sqrt(rho(0,1:nz-1)*mu(0,1:nz-1))*w(1,5,0,1:nz-1)

	w(1,1,0,1:nz-1)=w(1,1,0,1:nz-1)-
     &	1./sqrt(rho(0,1:nz-1)*(lam(0,1:nz-1)+2*mu(0,1:nz-1)))*w(1,3,0,
     &    1:nz-1)

	w(1,3,0,1:nz-1)=0.

	w(1,5,0,1:nz-1)=0.

c left boundary x=-1; ix=nx

	w(1,4,nx,1:nz-1)=w(1,4,nx,1:nz-1)-lam(nx,1:nz-1)/(lam(nx,1:nz-1)+2
     &      *mu(nx,1:nz-1))*w(1,3,nx,1:nz-1)

	w(1,2,nx,1:nz-1)=w(1,2,nx,1:nz-1)+
     &	1./sqrt(rho(nx,1:nz-1)*mu(nx,1:nz-1))*w(1,5,nx,1:nz-1)

	w(1,1,nx,1:nz-1)=w(1,1,nx,1:nz-1)+
     &	1./sqrt(rho(nx,1:nz-1)*(lam(nx,1:nz-1)+2*mu(nx,1:nz-1)))*w(1,3
     &    ,nx,1:nz-1)

	w(1,3,nx,1:nz-1)=0.

	w(1,5,nx,1:nz-1)=0.

c correct at four corners


	return
	end

c -------------------------------------------

	subroutine free_surface_and_absorbing

	include 'common.h'

c boundary treatment

c top boundary z=1; iz=0 : free surface 

	w(1,1,:,0)=w(1,1,:,0)-1./sqrt(rho(:,0)*mu(:,0))*w(1,5,:,0)

	w(1,2,:,0)=w(1,2,:,0)-1./sqrt(rho(:,0)*(lam(:,0)+2*mu(:,0)))*w(1,4
     &	,:,0)

	w(1,3,:,0)=w(1,3,:,0)-lam(:,0)/(lam(:,0)+2*mu(:,0))*w(1,4,:,0)

	w(1,4,:,0)=0.

	w(1,5,:,0)=0.

c bottom boundary z=-1; iz=nz : absorbing 

	w(1,1,:,nz)=0.5*(w(1,1,:,nz)+1./sqrt(rho(:,nz)*mu(:,nz))*w(1,5,:,
     &         nz))

	w(1,2,:,nz)=0.5*(w(1,2,:,nz)+1./sqrt(rho(:,nz)*(lam(:,nz)+2*mu(:,
     &          nz)))*	w(1,4,:,nz))

	w(1,3,:,nz)=w(1,3,:,nz)-lam(:,nz)/(2.*(lam(:,nz)+2*mu(:,nz)))*     
     &		    (w(1,4,:,nz)-sqrt(rho(:,nz)*(lam(:,nz)+2*mu(:,nz)))*     
     &						    w(1,2,:,nz))

	w(1,4,:,nz)=0.5*(w(1,4,:,nz)+    
     &	  sqrt(rho(:,nz)*(lam(:,nz)+2*mu(:,nz)))*w(1,2,:,nz))

	w(1,5,:,nz)=0.5*(w(1,5,:,nz)+     
     &	  sqrt(rho(:,nz)*mu(:,nz))*w(1,1,:,nz))


c right boundary x=1; ix=0   : absorbing


	w(1,1,0,:)=0.5*(w(1,1,0,:)-     
     &		1./sqrt(rho(0,:)*(lam(0,:)+2*mu(0,:)))*w(1,3,0,:))

	w(1,2,0,:)=0.5*(w(1,2,0,:)-     
     &	  1./sqrt(rho(0,:)*mu(0,:))*w(1,5,0,:))

	w(1,3,0,:)=0.5*(w(1,3,0,:)-     
     &	  sqrt(rho(0,:)*(lam(0,:)+2*mu(0,:)))*w(1,1,0,:))

	w(1,4,0,:)=w(1,4,0,:)-lam(0,:)/(2.*(lam(0,:)+2*mu(0,:)))*     
     &    (w(1,3,0,:)+sqrt(rho(0,:)*(lam(0,:)+2*mu(0,:)))*     
     &						    w(1,1,0,:))

	w(1,5,0,:)=0.5*(w(1,5,0,:)-     
     &	  sqrt(rho(0,:)*mu(0,:))*w(1,2,0,:))

c left boundary x=-1; ix=nx

	w(1,1,nx,:)=0.5*(w(1,1,nx,:)+     
     &		1./sqrt(rho(nx,:)*(lam(nx,:)+2*mu(nx,:)))*w(1,3,nx,:))

	w(1,2,nx,:)=0.5*(w(1,2,nx,:)+     
     &	  1./sqrt(rho(nx,:)*mu(nx,:))*w(1,5,nx,:))

	w(1,3,nx,:)=0.5*(w(1,3,nx,:)+     
     &	 sqrt(rho(nx,:)*(lam(nx,:)+2*mu(nx,:)))*w(1,1,nx,:))

	w(1,4,nx,:)=w(1,4,nx,:)-lam(nx,:)/(2.*(lam(nx,:)+2*mu(nx,:)))*     
     &	(w(1,3,nx,:)-sqrt(rho(nx,:)*(lam(nx,:)+2*mu(nx,:)))*w(1,1,nx,:))

	w(1,5,nx,:)=0.5*(w(1,5,nx,:)+     
     &	  sqrt(rho(nx,:)*mu(nx,:))*w(1,2,nx,:))

	return
	end

c -------------------------------------------------------------

	subroutine absorbing_boundaries

	include 'common.h'

c boundary treatment

c top boundary z=1; iz=0 : absorbing

	w(1,1,:,nz)=0.5*(w(1,1,:,nz)+     
     &	  1./sqrt(rho(:,nz)*mu(:,nz))*w(1,5,:,nz))

	w(1,2,:,nz)=0.5*(w(1,2,:,nz)+     
     &		1./sqrt(rho(:,nz)*(lam(:,nz)+2*mu(:,nz)))*w(1,4,:,nz))

	w(1,3,:,nz)=w(1,3,:,nz)-lam(:,nz)/(2.*(lam(:,nz)+2*mu(:,nz)))*     
     &	    (w(1,4,:,nz)-sqrt(rho(:,nz)*(lam(:,nz)+2*mu(:,nz)))* 
     &		w(1,2,:,nz))

	w(1,4,:,nz)=0.5*(w(1,4,:,nz)+     
     &	  sqrt(rho(:,nz)*(lam(:,nz)+2*mu(:,nz)))*w(1,2,:,nz))

	w(1,5,:,nz)=0.5*(w(1,5,:,nz)+     
     &	  sqrt(rho(:,nz)*mu(:,nz))*w(1,1,:,nz))



c bottom boundary z=-1; iz=nz : absorbing 

	w(1,1,:,0)=0.5*(w(1,1,:,0)-     
     &	 1./sqrt(rho(:,0)*mu(:,0))*w(1,5,:,0))

	w(1,2,:,0)=0.5*(w(1,2,:,0)-     
     &		1./sqrt(rho(:,0)*(lam(:,0)+2*mu(:,0)))*w(1,4,:,0))

	w(1,3,:,0)=w(1,3,:,0)-lam(:,0)/(2.*(lam(:,0)+2*mu(:,0)))*     
     &		    (w(1,4,:,0)+sqrt(rho(:,0)*(lam(:,0)+2*mu(:,0)))*     
     &					    w(1,2,:,0))

	w(1,4,:,0)=0.5*(w(1,4,:,0)-     
     &	  sqrt(rho(:,0)*(lam(:,0)+2*mu(:,0)))*w(1,2,:,0))

	w(1,5,:,0)=0.5*(w(1,5,:,0)-     
     &	  sqrt(rho(:,0)*mu(:,0))*w(1,1,:,0))


c right boundary x=1; ix=0   : absorbing


	w(1,1,0,:)=0.5*(w(1,1,0,:)-     
     &		1./sqrt(rho(0,:)*(lam(0,:)+2*mu(0,:)))*w(1,3,0,:))

	w(1,2,0,:)=0.5*(w(1,2,0,:)-     
     &	  1./sqrt(rho(0,:)*mu(0,:))*w(1,5,0,:))

	w(1,3,0,:)=0.5*(w(1,3,0,:)-     
     &	  sqrt(rho(0,:)*(lam(0,:)+2*mu(0,:)))*w(1,1,0,:))

	w(1,4,0,:)=w(1,4,0,:)-lam(0,:)/(2.*(lam(0,:)+2*mu(0,:)))*     
     &   (w(1,3,0,:)+sqrt(rho(0,:)*(lam(0,:)+2*mu(0,:)))* w(1,1,0,:))

	w(1,5,0,:)=0.5*(w(1,5,0,:)-     
     &	  sqrt(rho(0,:)*mu(0,:))*w(1,2,0,:))

c left boundary x=-1; ix=nx

	w(1,1,nx,:)=0.5*(w(1,1,nx,:)+     
     &		1./sqrt(rho(nx,:)*(lam(nx,:)+2*mu(nx,:)))*w(1,3,nx,:))

	w(1,2,nx,:)=0.5*(w(1,2,nx,:)+     
     &	  1./sqrt(rho(nx,:)*mu(nx,:))*w(1,5,nx,:))

	w(1,3,nx,:)=0.5*(w(1,3,nx,:)+     
     &	  sqrt(rho(nx,:)*(lam(nx,:)+2*mu(nx,:)))*w(1,1,nx,:))

	w(1,4,nx,:)=w(1,4,nx,:)-lam(nx,:)/(2.*(lam(nx,:)+2*mu(nx,:)))*     
     &	    (w(1,3,nx,:)-sqrt(rho(nx,:)*(lam(nx,:)+2*mu(nx,:)))*     
     &	    w(1,1,nx,:))

	w(1,5,nx,:)=0.5*(w(1,5,nx,:)+     
     &	  sqrt(rho(nx,:)*mu(nx,:))*w(1,2,nx,:))

	return
	end


c -------------------------------------------------------

	subroutine circular

	include 'common.h'

	real tmp(0:nx,0:nz)
	
c circular boundary conditions for testing

	do i=1,5
	tmp=w(1,i,:,:)
      w(1,i,1:nx-1,0) =tmp(1:nx-1,nz)
	w(1,i,1:nx-1,nz)=tmp(1:nx-1,0)
	w(1,i,0,1:nz-1) =tmp(nx,1:nz-1)
	w(1,i,nx,1:nz-1)=tmp(0,1:nz-1)
	end do

c corners

	do i=1,5
	tmp=w(1,i,:,:)
      w(1,i,0,0)   =.5*(tmp(1,0)+tmp(0,1))
	w(1,i,nx,nz) =.5*(tmp(nx-1,nz)+tmp(nx,nz-1))
	w(1,i,nx,0)  =.5*(tmp(nx-1,0)+tmp(nx,1))
	w(1,i,0,nz)  =.5*(tmp(0,nz-1)+tmp(1,nz))
	end do
	

	return
	end
