
clear
pause off 

disp(' ')
disp(' ------------------------------------------ ')
disp(' Basic plotting for 1-Component seismograms ')
disp(' ------------------------------------------ ')
disp(' ')

dir

file1=input(' Give filename for x component (in single quotes) ');
if ~exist(file1), disp(' File (x) not found '),break, end
disp(' Loading x-component ')
eval(['load -ascii ' file1]);

nt=input(' Number of time samples (nt) ? ');
dt=input(' Time increment (dt) in micros (input 1 if not known)? ');

s1=eval([file1]);


nr=length(s1)/nt;
%inc=input(' Receiver increment for plotting (>=1) ? ');
inc=1;
%off=input(' Receiver offset  ? ');
off=.5;

s1=reshape(s1',nt,nr); 

t=(1:nt)*dt;

% find max
rmax=max(max(abs(s1)));

iinc=0;
s1i=zeros([nt,nr/inc]);

% preparing seismograms for plots
for i=1:inc:nr,
iinc=iinc+1;
s1i(:,iinc)=s1(:,i)+(iinc-1)*rmax*off;
end

plot(t,s1i),title(sprintf(' %s ',file1)),xlabel(' Time (sec) '),
axis([0 max(t) -rmax*off nr/inc*rmax*off]),pause

% ans=input(' Print plot to PS file (1) ? ');
% 
% if ans == 1,
% disp(' Writing plot to file seis.eps ')
% print -deps seis.eps
% end

disp(' ... bye ...')
