!*****************************************************************************
!***************** Output of seismogram and snapshot files********************
!*****************************************************************************

SUBROUTINE fd3s_output

    IMPLICIT NONE
    INCLUDE 'common_global.h'

    REAL seisx(maxnr*maxnt),seisy(maxnr*maxnt),seisz(maxnr*maxnt) 
    REAL seisdiv(maxnr*maxnt),seisrot(maxnr*maxnt)
    REAL out 

    INTEGER nrt,lnblnk
    INTEGER iss

    nrt=nt/isamp       ! isamp: seismogram sampling rate
	
    IF(maxnt*maxnr<nrt*nr)THEN
       WRITE(*,*)' maxnt*maxnr<nrt*nr ! Change maxnr in params.h ! '
       STOP
    ENDIF

!=============================================================================

! seismograms just for surface

    DO i=1,nr

! theta velocity comp. interpolated from 4 horizontally adjacent grid points

     seisx((i-1)*nrt+it)= (w11(ilowx(i),jlowx(i),izfree)*xqotminx(i)+ &
                          w11(iupx(i),jlowx(i),izfree)*xqotx(i))*yqotminx(i)+ &
                          (w11(ilowx(i),jupx(i),izfree)*xqotminx(i)+ &
                          w11(iupx(i),jupx(i),izfree)*xqotx(i))*yqotx(i)


! phi velocity comp. interpolated from 4 horizontally adjacent grid points

     seisy((i-1)*nrt+it)= (w12(ilowy(i),jlowy(i),izfree)*xqotminy(i)+ &
                          w12(iupy(i),jlowy(i),izfree)*xqoty(i))*yqotminy(i)+ &
                          (w12(ilowy(i),jupy(i),izfree)*xqotminy(i)+ &
                          w12(iupy(i),jupy(i),izfree)*xqoty(i))*yqoty(i)   
       

! vert. vel. comp. interpolated from 4 horizontally adjacent grid points, 
! and from the grid points dz/2 above and below the free surface.

     seisz((i-1)*nrt+it)= ( (w13(ilowz(i),jlowz(i),izfree)+ &
                          w13(ilowz(i),jlowz(i),izfree-1))*0.5*xqotminz(i)+ &
                          (w13(iupz(i),jlowz(i),izfree)+ &
                    w13(iupz(i),jlowz(i),izfree-1))*0.5*xqotz(i))*yqotminz(i)+&
                    ( (w13(ilowz(i),jupz(i),izfree)+ &
                       w13(ilowz(i),jupz(i),izfree-1))*0.5*xqotminz(i)+ &
                       (w13(iupz(i),jupz(i),izfree)+ &
                        w13(iupz(i),jupz(i),izfree-1))*0.5 *xqotz(i))*yqotz(i) 


!=============================================================================

! curl and divergence of velocity components

    IF (rotdiv==1) THEN

       seisdiv((i-1)*nrt+it)= (divsurf(ilowz(i),jlowz(i))*xqotminz(i)+ &
                           divsurf(iupz(i),jlowz(i))*xqotz(i))*yqotminz(i)+ &
                           (divsurf(ilowz(i),jupz(i))*xqotminz(i)+ &
                           divsurf(iupz(i),jupz(i))*xqotz(i))*yqotz(i) 
     
       seisrot((i-1)*nrt+it)= (rotsurf(ilowz(i),jlowz(i))*xqotminz(i)+ &
                           rotsurf(iupz(i),jlowz(i))*xqotz(i))*yqotminz(i)+ &
                           (rotsurf(ilowz(i),jupz(i))*xqotminz(i)+ &
                           rotsurf(iupz(i),jupz(i))*xqotz(i))*yqotz(i) 
    ENDIF

    ENDDO

!=============================================================================

! write velocity component seismograms
       
    IF(it .GE. nt*2./3.) THEN       ! start saving at 66% of the total run time
       IF(MOD(it,iflush) .EQ.0..OR.it .EQ.nt)THEN  
 
         OPEN(unit=10,file=seisfile(1:lnblnk(seisfile))//'_x')
	 OPEN(unit=11,file=seisfile(1:lnblnk(seisfile))//'_y')
	 OPEN(unit=12,file=seisfile(1:lnblnk(seisfile))//'_z')

         WRITE(*,*)''
         WRITE(*,*)'.... Writing seismograms to file ....' 
         WRITE(*,*)''

	 DO i=1,nr*nrt
	   WRITE(10,*)seisx(i)
	   WRITE(11,*)seisy(i)
	   WRITE(12,*)seisz(i)
	 ENDDO

	 CLOSE(10)
	 CLOSE(11)
	 CLOSE(12)

! write curl and div seismograms

    IF (rotdiv==1) THEN
       OPEN(unit=13,file=seisfile(1:lnblnk(seisfile))//'_rot')
       OPEN(unit=14,file=seisfile(1:lnblnk(seisfile))//'_div')  
   
       WRITE(*,*)'.... Writing ROT & DIV seismograms to file ....' 
       WRITE(*,*)''

       DO i=1,nr*nrt
	 WRITE(13,*)seisrot(i)
	 WRITE(14,*)seisdiv(i)
       ENDDO

       CLOSE(13)
       CLOSE(14)

    ENDIF ! rotdiv switch

    ENDIF ! after 66% of run time 
    
    ENDIF ! equal to flush intervals 
 

!=============================================================================

! Snapshots, just if no delta pulse inserted

    IF (aa .NE. 0 ) THEN


! Snapshots of stress tensor trace E_ii, curl, and divergence
 
 IF(it==1.AND.ssamp>0)THEN

  OPEN(unit=67,file=seisfile(1:lnblnk(seisfile))//'_Xvs',status='unknown')
  OPEN(unit=68,file=seisfile(1:lnblnk(seisfile))//'_Yvs',status='unknown')
  OPEN(unit=52,file=seisfile(1:lnblnk(seisfile))//'_divx',status='unknown')
  OPEN(unit=53,file=seisfile(1:lnblnk(seisfile))//'_rotx',status='unknown') 
  OPEN(unit=54,file=seisfile(1:lnblnk(seisfile))//'_divy',status='unknown') 
  OPEN(unit=55,file=seisfile(1:lnblnk(seisfile))//'_roty',status='unknown') 
  OPEN(unit=56,file=seisfile(1:lnblnk(seisfile))//'_divsurf',status='unknown') 
  OPEN(unit=57,file=seisfile(1:lnblnk(seisfile))//'_rotsurf',status='unknown') 

 ENDIF

! files are left open to continue writing for each snapshot

    IF(ssamp>0)THEN

      IF(MOD(it,ssamp)==0)THEN  

	iss=it/ssamp
	WRITE(*,*)' Writing vol. snapshots ',iss,' to file '

! Plane of Theta=const.

       DO i=0,ny
	 DO j=izfree,nz 
           WRITE(67,*)w14(iplanex,i,j)+w15(iplanex,i,j)+w16(iplanex,i,j)
           WRITE(52,*)divx(i,j)
           WRITE(53,*)rotx(i,j)
	 ENDDO
       ENDDO


! Plane of Phi=const.

      DO i=0,nx
         DO j=izfree,nz
          WRITE(68,*)w14(i,iplaney,j)+w15(i,iplaney,j)+w16(i,iplaney,j)
          WRITE(54,*)divy(i,j) 
          WRITE(55,*)roty(i,j)
         ENDDO
      ENDDO


! Surface

      OPEN(unit=69,file=seisfile(1:lnblnk(seisfile))//'_Zvs',status='unknown')
       DO i=0,nx
         DO j=0,ny
           WRITE(69,*)w14(i,j,izfree)+w15(i,j,izfree)+w16(i,j,izfree)
           WRITE(56,*)divsurf(i,j)
           WRITE(57,*)rotsurf(i,j) 
         ENDDO
       ENDDO
    ENDIF

    ENDIF


!=============================================================================

! Snapshots of velocity components

    IF(it==10.AND.ssamp>0)THEN

      OPEN(unit=77,file=seisfile(1:lnblnk(seisfile))//'_Xxs',status='unknown')
      OPEN(unit=87,file=seisfile(1:lnblnk(seisfile))//'_Yxs',status='unknown')
      OPEN(unit=78,file=seisfile(1:lnblnk(seisfile))//'_Xys',status='unknown')
      OPEN(unit=88,file=seisfile(1:lnblnk(seisfile))//'_Yys',status='unknown')
      OPEN(unit=79,file=seisfile(1:lnblnk(seisfile))//'_Xzs',status='unknown')
      OPEN(unit=89,file=seisfile(1:lnblnk(seisfile))//'_Yzs',status='unknown')

    ENDIF

    IF(ssamp>0)THEN

      IF(MOD(it,ssamp)==0)THEN

	iss=it/ssamp
        WRITE(*,*)' Writing snapshots ',iss,' to file '

! Plane at Theta=const.

        DO i=0,ny
           DO j=izfree,nz
	      WRITE(77,*)w11(iplanex,i,j)
	      WRITE(78,*)w12(iplanex,i,j)
	      WRITE(79,*)w13(iplanex,i,j)
	   ENDDO
	ENDDO

! Plane at Phi=const.

        DO i=0,nx
           DO j=izfree,nz
              WRITE(87,*)w11(i,iplaney,j)
              WRITE(88,*)w12(i,iplaney,j)
              WRITE(89,*)w13(i,iplaney,j)
           ENDDO
        ENDDO

! Surface

     OPEN(unit=97,file=seisfile(1:lnblnk(seisfile))//'_Zxs',status='unknown')
     OPEN(unit=98,file=seisfile(1:lnblnk(seisfile))//'_Zys',status='unknown')
     OPEN(unit=90,file=seisfile(1:lnblnk(seisfile))//'_Zzs',status='unknown')

       DO i=0,nx
          DO j=0,ny
            WRITE(97,*)w11(i,j,izfree)
            WRITE(98,*)w12(i,j,izfree)
            WRITE(90,*)w13(i,j,izfree)
          ENDDO
       ENDDO

   ENDIF    ! mod(it,ssamp)==0

   ENDIF    ! ssamp>0

   ENDIF    ! saving snapshots based on whether aa=0 and alpha=0

   RETURN

END SUBROUTINE fd3s_output
	
!=============================================================================










