!*****************************************************************************
!***************** Main Program for spherical FD code ************************
!*****************************************************************************

PROGRAM fd3s_main

    IMPLICIT NONE

    INCLUDE 'common_global.h'

    REAL secnds,start,realnt,realit
    INTEGER val(8),newmin
        
    REAL*8 ta,te,partime(4)    ! variables for run time control
    CHARACTER*8 date1,date2
    CHARACTER*10 time1,time2      

    outfile='output/output_file_name'     !  Log file 

    OPEN(unit=99,file=outfile)            ! open log file
        
    CALL DATE_AND_TIME(date1,time1)       ! time control 
         
    WRITE(99,*)' =================================== '
    WRITE(99,*)' '
    WRITE(99,*)'         Spherical FD Method       '
    WRITE(99,*)'      3-D isotropic elastic case   '
    WRITE(99,*)'           Serial version          '
    WRITE(99,*)'             March 2002            '
    WRITE(99,*)'          Tarje Nissen-Meyer       '
    WRITE(99,*)' '
    WRITE(99,*)' ==================================='
        
      WRITE(99,*)''
      WRITE(99,*)'Date :',date1,',Time :',time1
      WRITE(*,*)''
      WRITE(*,*)'Date :',date1,',Time :',time1    

      WRITE(99,*)' '

!=============================================================================

! read parameters from files 'Par' and 'recfile'

    CALL fd3s_input

!=============================================================================

! various initializations (model space, source, receivers, boundaries)

    CALL fd3s_init

!=============================================================================

! background model
 
    CALL fd3s_model
      
!=============================================================================

! the Graves free surface method (see fd3s_evolution.f90):
! initialization of predefined parameters

    IF (fs_model == 1) THEN

! 2D elastic-geometrical parameters
      xi=1+(zs(izfree)/dz*(1+2*(mu(:,:,izfree)/lam(:,:,izfree))))
      eta=1/(xi-2)

! 1D geometrical parameters
      alph=dz/(zs(izfree)-dz/2)          
      beta=1/(1+1/alph)                   
      gamma=1-alph/2                      
      delta=-(alph+beta)   
               
    ENDIF

!=============================================================================

! check whole setup
 
    CALL fd3s_check

!=============================================================================

! start time evolution

    start=secnds(0.0)

    DO it=1,nt                       ! loop over time  

! Delta pulse as source time function
      IF(aa==0.)THEN
 
	IF(it .GE. it0) THEN        ! insert delta source after it0 timesteps
          IF (MOD(it,20) .EQ. 0) THEN 
            WRITE(*,*)'time step:',it  
            WRITE(99,*)'time step:',it
          ENDIF
	  CALL fd3s_evolution       ! calculate FD solutions for delta source
	ENDIF

! smooth wavelet as source time function
      ELSE

        IF (MOD(it,20) .EQ. 0) THEN
!          WRITE(*,*)'time step:',it,' rank :',myrank
          WRITE(*,*)'time step:',it
          WRITE(99,*)'time step:',it
        ENDIF
	CALL fd3s_evolution         ! calculate FD solutions for wavelet source

      ENDIF

!=============================================================================

! simulation time and estimation of total run time 

      IF (MOD(it,20).EQ.0) THEN       ! output every 20 time steps  

         WRITE(*,*)'%%%%%%%%% TIME SCHEDULE %%%%%%%%%%%%%%'
         WRITE(99,*)'%%%%%%%%% TIME SCHEDULE %%%%%%%%%%%%%%'
 
           realnt=nt
           realit=it
           WRITE(*,*)''
           WRITE(*,*)'**************************************'
           WRITE(*,*)'Needed time:',secnds(start)/60,' min'
           WRITE(*,*)'Time left  :',secnds(start)/60*(realnt/realit-1.),' min'

             CALL DATE_AND_TIME(values=val)
             
              newmin=val(6)+secnds(start)/60*(realnt/realit-1.)
              IF (newmin >= 60) THEN
                   val(5)=val(5)+newmin/60
                   val(6)=MOD(newmin,60)
              ELSE
                   val(6)=newmin
              ENDIF
              IF (val(5)>=24) THEN
                val(3)=val(3)+val(5)/24
                val(5)=MOD(val(5),24)
              ENDIF         
              WRITE(*,*)'Iteration approx. finished at:',&
                    val(5),'h',val(6),'min, ',val(3),'.',val(2),'.' 
              WRITE(*,*)'**************************************'
              WRITE(*,*)''



         WRITE(*,*)'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%' 
         WRITE(99,*)'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%' 

      ENDIF	

!=============================================================================

! Save wavefield values to file for seismograms and/or snapshots

      CALL fd3s_output  
     
!=============================================================================

    ENDDO   ! end of time evolution

        CALL DATE_AND_TIME(values=val)
        WRITE(*,*)'============================================='
        WRITE(*,*)'fd3s_main.x finished at:',val(5),'h',&
                  val(6),'min, ',val(3),'.',val(2),'.'
        WRITE(*,*)'============================================='

    CALL DATE_AND_TIME(date2,time2)

    WRITE(*,*)'Starting time : ',time1
    WRITE(*,*)'Finishing time: ',time2
    WRITE(99,*)'Starting time : ',time1
    WRITE(99,*)'Finishing time: ',time2   
    WRITE(99,*)'Date : ',date2
    WRITE(*,*)'Date : ',date2 

    CLOSE(99)  ! close log file


END PROGRAM fd3s_main


!########### Additional subroutine ###########################################

! subroutine to add variable integers to a character string

SUBROUTINE add_num_to_char(file,i)
    
        IMPLICIT NONE
        CHARACTER*50 file
        CHARACTER*4 ichar

        INTEGER i,in,lnblnk

        IF(i.LT.10)THEN
          WRITE(ichar,'(i1)') i
          in=1
        ELSEIF(i.LT.100)THEN
          WRITE(ichar,'(i2)') i
          in=2
        ELSEIF(i.LT.1000)THEN
          WRITE(ichar,'(i3)') i
          in=3
        ELSEIF(i.LT.10000)THEN
          WRITE(ichar,'(i4)') i
          in=4
        ELSE
          WRITE(*,*)' Warning : number too large !!! '
        ENDIF
 
        file = file(1:lnblnk(file))//ICHAR(1:in)
 
        RETURN
        END SUBROUTINE add_num_to_char
 






