

% this program aims at clarifying the concept of prior information
%
% we want to generate "likely" depth dependent earth models with 
% varying layer thicknesses and densities

ntrial=10000;


% Densities are described by a log normal distribution
nro=100;    % number of point in ro axis
romax=25;   % maximum density
ro=romax/nro:romax/nro:romax;    % densitiy ranges from 1-25 g/cm3
roinv=1./ro;    % lightness
ro0=5;
s=.2;
pdfro=1./(sqrt(2*pi)*s)*roinv.*exp(-1/(2*s^2).*log10(ro/ro0).^2);
pdfro=pdfro/sum(pdfro);

% Generate random density values and check whether they approach the
% theoretical distribution
modelsro=pdfro*0;

for i=1:ntrial,
    mro=ceil(rand*nro);
    prob=pdfro(mro)/max(pdfro);    % that is a number betwen 0 and 1
    test=rand;
    if test < prob, 
        modelsro(mro)=modelsro(mro)+1;
    else
        modelsro(mro)=modelsro(mro);
    end
end

% Layer thicknesses
nld=100;    % number of point in layer thickness axis
lmax=50;   % maximum layer
ld=lmax/nl:lmax/nl:lmax;    % densitiy ranges from 1-25 g/cm3
pdfld=1./ld;
pdfld=pdfld/sum(pdfld);


% Generate random thickness values and check whether they approach the
% theoretical distribution
modelsld=pdfld*0;

for i=1:ntrial,
    mld=ceil(rand*nld);
    prob=pdfld(mld)/max(pdfld);    % that is a number betwen 0 and 1
    test=rand;
    if test < prob, 
        modelsld(mld)=modelsld(mld)+1;
    else
        modelsld(mld)=modelsld(mld);
    end
end

subplot(121),plot(ro,pdfro,'k-',ro,modelsro/max(modelsro)*max(pdfro),'r-')
xlabel(' Ro (g/cm^3) ')
ylabel(' Prob (ro) ')

subplot(122),plot(ld,pdfld,'k-',ld,modelsld/max(modelsld)*max(pdfld),'r-')
xlabel(' D (m) ')
ylabel(' Prob (D) ')


% Generate random Earth models following the prior probabilities

nmodels=9;
iplot=3;
jplot=3;

for i=nmodels,

im=get_index_from_pdf(pdfro);
modelsro(im)=modelsro(im)+1;
im=get_index_from_pdf(pdfld);
modelsld(im)=modelsld(im)+1;

end
