
clear 
clf
close all

% Hypo2002
% a programme to use probabilistic inverse theory 
% to determine hypocenter locations (highly simplified)
% here simplified to a 2D problem, but extendable to 3D

% real data example for the Bad Reichenhall area:

% Real data in original form

% Arrival times
% -----EV0111
% STAUIPU0 020410165347.69       48.29IS?1
% RMOAIPU0 020410165347.68       48.12IS?0
% RJOBIPD0 020410165347.78       48.42IS?0
% RWMOIPU0 020410165348.53       50.09IS?4
% RNHAIPU0 020410165348.67       50.09IS?2
% RHAMIPU0 020410165348.91       50.33IS?3 
tobs=[48.29 48.12 48.42 50.09 50.09 50.33]-48;

% W weight (0: <0.05s  1: <0.1s 2:<0.5s 3:<1.0; 4:sonst) 

% station coordinates:
%   SSSS ---LAT--- ---LON--- ALT-
%   RHAM 47 48.24N 12 43.22E  799
%   RJOB 47 44.23N 12 47.74E  860
%   RMOA 47 45.70N 12 51.87E  814
%   RNHA 47 48.34N 12 49.13E  855
%   RTBE 47 44.71N 12 49.44E 1161
%   RTFS 47 45.84N 12 49.04E  938
%   RTSB 47 44.84N 12 53.90E  472
%   RWMO 47 44.65N 12 43.79E  763
%   STAU 47 44.43N 12 52.03E  555 

% prepare for inversion
sz=[555 814 860 763 855 799]/1000;	    % altitude
slat=47+1/60.*[44.43 45.7 44.23 44.65 48.34 48.24];
slon=12+1/60.*[52.03 51.87 47.7 43.79 49.13 43.22];
sobs=[0.5 0.1 0.1 2 .5 1];
sobs=1*sobs;


[x,y,z] = sph2cart(slon/180*pi,slat/180*pi,6371);
[x0,y0,z0]=sph2cart(mean(slon)/180*pi,mean(slat)/180*pi,6371);

plot3(x-x0,y-y0,sz,'+'),xlabel('x'),ylabel('y'),zlabel('z');
sx=x-x0;
sy=y-y0;
ns=length(sx);						% number of stations (and observations)

% info on data
disp(' Observations and network ')
disp(' ')
disp(sprintf(' Number of  stations: %i ',ns))
disp(sprintf(' %g km < x < %g km ',min(sx),max(sx)))
disp(sprintf(' %g km < y < %g km ',min(sy),max(sy)))
disp(sprintf(' %g km < z < %g km ',min(sz),max(sz)))
disp(sprintf(' %g s < t < %g s ',min(tobs),max(tobs)))



pause
if length(sobs) ~= ns, disp(' Please adjust vector length (sobs) '), pause, end
t=tobs*0;         % vector used later



% Define model space and increments for model exploration
xa=0; xe=20; xinc=1;			% upper and lower bounds in x0
ya=0; ye=15; yinc=1;            % y0
za=-5; ze=1; zinc=.4;           % z0
Ta=-4.; Te=-0.5; Tinc=.25;         % t0
va=2.5; ve=5.5; vinc=.25;        % v
nx=(xe-xa)/xinc+1;              % number of sample in dimension x0
ny=(ye-ya)/yinc+1;              % y0
nz=(ze-za)/zinc+1;              % z0
nT=(Te-Ta)/Tinc+1;              % t0
nv=(ve-va)/vinc+1;              % v
sv=1000; v0=4.5;

% Now let s solve the inverse problem
% Some parameters
ntot=nv*nx*ny*nz*nT;               % total number of forward modellings to do
nm=round(ntot/100);                    % info after ntot/100 samples 
nn=0;

disp(sprintf(' Proceed to calculate a posteriori pdf for %i x %i x %i x %i x %i = %i samples ? ',nv,nx,ny,nz,nT,ntot))
disp(' Press any key to continue ')
pause
disp(' Starting exploration of model space ... ')



% We now loop through the model space (x,y,z, and T)

sigD=zeros([nv nx ny nz nT]);      % initilization of pdf to 0

% Loop through model space

iv=0;
for v=va:vinc:ve,
iv=iv+1;

ix=0;
for x=xa:xinc:xe,
   ix=ix+1;
   iy=0;
   for y=ya:yinc:ye,
      iy=iy+1;
 			iz=0;
 			%iy=1;
			 %y=0;
      for z=za:zinc:ze,
         iz=iz+1;
         iT=0;
        for T=Ta:Tinc:Te,
            iT=iT+1;
            % calculate forward problem
            
            for is=1:ns,    % loop over number of observables
            t(is)=T+1/v*sqrt((x-sx(is))^2+(y-sy(is))^2+(z-sz(is))^2);
            end
        
            % calculate the associated probability
            
                term=1;
            for is=1:ns,    % loop over number of observables
                term=term*exp(-1/(2*sobs(is)^2)*(t(is)-tobs(is))^2);
            end
            sigM(iv,ix,iy,iz,iT)=term*exp(-1/(2*sv^2)*(v-v0)^2);         % 
          
                                      nn=nn+1;
                                      if rem(nn,nm)==0, 
                                         disp(sprintf(' Calculated %g %%',round(nn/ntot*100)))
                                      end
                                      
                          end
                      end
                  end
            end
            
        end
               
               
               
% Calculate the marginal a posteriori probabilities for plotting

% volume x-y-z
sigMxyz=zeros([iy ix iz]);
for i=1:ix,
    for j=1:iy
        for k=1:iz,
      sigMxyz(j,i,k)=sum(sum(sum(sigM(:,i,j,k,:))));
        end
  end
end


% plot volume of high probability
figure
% normalize marginals for plotting
sigMxyz=sigMxyz/max(max(max(sigMxyz)));

[xx yy zz]=meshgrid(xa:xinc:xe,ya:yinc:ye,za:zinc:ze);

       p = patch(isosurface(xx, yy, zz, sigMxyz, .9));
       isonormals(xx,yy,zz,sigMxyz, p)
       set(p, 'FaceColor', 'red', 'EdgeColor', 'none');
       daspect([1 1 1])
       view(3)
       camlight; lighting phong
%        drawnow 
%        pause
%        hold on
%        plot3(x-x0,y-y0,sz,'+'),xlabel('x'),ylabel('y'),zlabel('z');
%        hold off
   
% plot marginals in space 
figure       
       
% plane x-z
sigMxz=zeros([ix iz]);
for i=1:ix,
   for j=1:iz,
      sigMxz(i,j)=sum(sum(sum(sigM(:,i,:,j,:))));
      end
end

% normalize marginals for plotting
sigMxz=sigMxz/max(max(sigMxz));

% plane x-y
sigMxy=zeros([ix iy]);
for i=1:ix,
   for j=1:iy,
      sigMxy(i,j)=sum(sum(sum(sigM(:,i,j,:,:))));
      end
end

% normalize marginals for plotting
sigMxy=sigMxy/max(max(sigMxy));

% plane y-z
sigMyz=zeros([iy iz]);
for i=1:iy,
   for j=1:iz,
      sigMyz(i,j)=sum(sum(sum(sigM(:,:,i,j,:))));
      end
end

% normalize marginals for plotting
sigMyz=sigMyz/max(max(sigMyz));


x=xa:xinc:xe;
y=ya:yinc:ye;
z=za:zinc:ze;


subplot(131)
imagesc(interp(x,4),interp(z,4),interp2(sigMxz',4)), hold on
xlabel(' x(km) ')
ylabel(' z(km) ')
title(' A posteriori probability: hypocenter ')

for i=1:ns
    plot(sx(i),sz(i),'r+'), hold on
end
hold off

subplot(132)
imagesc(interp(x,4),interp(y,4),interp2(sigMxy',4)), hold on
xlabel(' x(km) ')
ylabel(' y(km) ')
title(' A posteriori probability: hypocenter ')

for i=1:ns
    plot(sx(i),sy(i),'r+'), hold on
end
hold off

subplot(133)
imagesc(interp(y,4),interp(z,4),interp2(sigMyz',4)), hold on
xlabel(' y(km) ')
ylabel(' z(km) ')
title(' A posteriori probability: hypocenter ')

for i=1:ns
    plot(sy(i),sz(i),'r+'), hold on
end
hold off


figure
% other marginals

%  marginal a posteriori for T
for i=1:nT,sigMT(i)=sum(sum(sum(sum(sigM(:,:,:,:,i))))); end
s=sum(sigMT);
sigMT=sigMT/s;

%  prior for T
for i=1:nT,roMT(i)=1; end
s=sum(roMT);
roMT=roMT/s;

%  marginal a posteriori for v
for i=1:nv,sigMv(i)=sum(sum(sum(sum(sigM(i,:,:,:,:))))); end
s=sum(sigMv);
sigMv=sigMv/s;

% prior in v
for i=1:nv,roMv(i)=exp(-1/(2*sv^2)*((va+(i-1)*vinc)-v0)^2); end
s=sum(roMv);
roMv=roMv/s;

%  marginal a posteriori for x
for i=1:nx,sigMx(i)=sum(sum(sum(sum(sigM(:,i,:,:,:))))); end
s=sum(sigMx);
sigMx=sigMx/s;

%  prior for x
for i=1:nx,roMx(i)=1; end
s=sum(roMx);
roMx=roMx/s;

%  marginal a posteriori for z
for i=1:nz,sigMz(i)=sum(sum(sum(sum(sigM(:,:,:,i,:))))); end
s=sum(sigMz);
sigMz=sigMz/s;

%  prior for z
for i=1:nz,roMz(i)=1; end
s=sum(roMz);
roMz=roMz/s;


subplot(141)
plot(Ta:Tinc:Te,sigMT,'k-',Ta:Tinc:Te,roMT,'r-')
xlabel(' Origin time (s) ')
ylabel(' Probability')
title(' A posteriori (black) - prior (red) probability: origin time ')

subplot(142)
plot(va:vinc:ve,sigMv,'k-',va:vinc:ve,roMv,'r-')
xlabel(' Velocity (km/s) ')
ylabel(' Probability')
title(' A posteriori (black) - prior (red) probability: velocity ')

subplot(143)
plot(xa:xinc:xe,sigMx,'k-',xa:xinc:xe,roMx,'r-')
xlabel(' Source location x (km) ')
ylabel(' Probability')
title(' A posteriori (black) - prior (red) probability: x ')

subplot(144)
plot(za:zinc:ze,sigMz,'k-',za:zinc:ze,roMz,'r-')
xlabel(' Source location z (km) ')
ylabel(' Probability')
title(' A posteriori (black) - prior (red) probability: z ')
